<?php
/*
Plugin Name: TranslatePress - Cleanup Database
Plugin URI: https://translatepress.com/
Description: Cleans up the translation database of external links or various texts like calendar links while also prevents those links from entering the database in the future. WordPress -> Settings -> TranslatePress Cleanup Database
Version: 1.4
Author: TranslatePress
License: GPL2
*/

define('TPCLEANUP_DIR', dirname(__FILE__));
define('TPCLEANUP_URL', plugins_url('', __FILE__));
define('TPCLEANUP_PLUGIN_SLUG', plugin_basename(__FILE__));

if (!class_exists(\TranslatePressCleanupDb::class, false)) {
    /**
     * Main Class TranslatePressCleanupDb
     */
    class TranslatePressCleanupDb{

        private static $instance;

        /**
         * Set needed filters and actions and load.
         */
        private function __construct(){
            if (file_exists(__DIR__ . '/vendor/autoload.php')) {
                require_once __DIR__ . '/vendor/autoload.php';
            }

            // Init Admin Settings Page
            new TranslatePressCleanupDb\Admin\SettingsPage;

            if(class_exists('\TRP_Translate_Press') && current_user_can('manage_options')){
                // Init Ajax Processing
                new TranslatePressCleanupDb\Admin\CleanupDatabase;

                // Init Ajax Processing
                new TranslatePressCleanupDb\Admin\CleanupEncodedEmails;

                // Init Ajax Processing
                new TranslatePressCleanupDb\Admin\CleanupFailedDbOptimization;

                // Exclude certain types of strings from ending up in the database
                new TranslatePressCleanupDb\Admin\ExcludeStrings;
            }
        }

        /**
         * @return self
         */
        public static function get_instance(): TranslatePressCleanupDb
        {
            if (null === self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }

    // Start the plugin.
    add_action('plugins_loaded', [TranslatePressCleanupDb::class, 'get_instance'], 20);
}