<div class="wrap">
    <div class="notice notice-warning"><p><strong>Warning:</strong> Please make sure you've backed up your database before running any cleanup process. </p></div>

    <div style="max-width: 900px;">
        <h1>Cleanup TranslatePress Tables</h1>
        <hr style="margin: 40px 0;">
        <h2>Cleanup Original texts that contain the partial texts bellow</h2>
        <p>Cleanup wp_trp_dictionary_* tables of <strong>external url's</strong> or any strings that match the strings in the textarea bellow. </p>
        <p><strong>As long as this plugin is active, these strings will also be excluded from entering the translation database moving forward.</strong></p>
        <form method="post" name="translatepress-cleanup-form">
            <?php wp_nonce_field( 'translatepress-cleanup-db'); ?>
            <p><label for="line_separated_texts">List of external urls & texts to remove from the database.</label></p>
            <p><textarea name="line_separated_texts" style="width: 414px; height: 200px;"><?php
            $line_separated_texts = get_option('trpc_cleanup_line_separated_texts', "");
            echo $line_separated_texts;
    ?></textarea>
            </p>
            <p><label for="batch">Batch Size</label><input type="number" name="batch-size" value="10000" />
            <input type="submit" value="Start Database Cleanup" class="button"></p>
        </form>
    </div>

    <hr style="margin: 40px 0;">

    <div style="max-width: 900px;">
        <h2>Cleanup html encoded emails from the database</h2>
        <p>It's possible to end up with large number of emails that are html encoded in the database as a way to stop spam.</p>
        <p><strong>Example:</strong> instead of hello@example.com you'll have something like this in the wp_trp_dictionary_* tables.</p>
        <code><span class="hljs-symbol">&amp;#104;</span><span class="hljs-symbol">&amp;#101;</span><span class="hljs-symbol">&amp;#108;</span><span class="hljs-symbol">&amp;#108;</span><span class="hljs-symbol">&amp;#111;</span><span class="hljs-symbol">&amp;#64;</span><span class="hljs-symbol">&amp;#101;</span><span class="hljs-symbol">&amp;#120;</span><span class="hljs-symbol">&amp;#97;</span><span class="hljs-symbol">&amp;#109;</span><span class="hljs-symbol">&amp;#112;</span><span class="hljs-symbol">&amp;#108;</span><span class="hljs-symbol">&amp;#101;</span><span class="hljs-symbol">&amp;#46;</span><span class="hljs-symbol">&amp;#99;</span><span class="hljs-symbol">&amp;#111;</span><span class="hljs-symbol">&amp;#109;</span>
        </code>

        <form method="post" name="translatepress-cleanup-encoded-emails-form">
            <?php wp_nonce_field( 'translatepress-cleanup-encoded-emails'); ?>
            <h4><label for="line_separated_encoded_emails">List of emails, one per line:</label></h4>
            <p><textarea name="line_separated_encoded_emails" style="width: 414px; height: 200px;"><?php
    $line_separated_encoded_emails = get_option('trpc_cleanup_line_separated_encoded_emails', "");
    echo $line_separated_encoded_emails;
    ?></textarea>
            </p>

            <p><label for="batch">Batch Size</label><input type="number" name="batch-size" value="100000" />
                <input type="submit" value="Start Database Cleanup" class="button"></p>
        </form>
    </div>


    <div style="max-width: 900px; margin-top: 100px;">
        <h2 style="">Cleanup Failed DB Optimization Script</h2>
        <p>Cleanup wp_trp_original_strings123* tables that were generated by the DB Optimization Script that can fail with large databases. </p>

        <form method="post" name="translatepress-cleanup-failed-db-optimization-form">
            <?php wp_nonce_field( 'translatepress-cleanup-failed-db-optimization'); ?>
            <!-- <label for="batch">Batch Size</label><input type="number" name="batch-size" value="2000" /> -->
            <input type="submit" value="Start Database Cleanup" class="button">
        </form>
    </div>



</div>