<?php
namespace TranslatePressCleanupDb\Admin;

class SettingsPage
{
    public function __construct()
    {
        add_action('admin_menu', [$this, 'add_menu']);
        add_action('admin_head', [$this, 'remove_all_notices']);
        add_filter('plugin_action_links_' . TPCLEANUP_PLUGIN_SLUG, [$this,  'add_settings_link']);

    }

    public function add_menu()
    {
        add_options_page(
            'TranslatePress Cleanup Database',
            'TranslatePress Cleanup Database',
            'manage_options',
            'translatepress-cleanup-db',
            [$this, 'render_page']
        );
    }

    public function render_page()
    {
        if(class_exists('\TRP_Translate_Press')){
            include TPCLEANUP_DIR . '/src/Templates/cleanup.php';
        } else {
            echo "<div class='wrap'><h1>Please Activate TranslatePress main plugin. This does not work without it</h1></div>";
        }

    }

    public function remove_all_notices()
    {
        $screen = get_current_screen();

        // Check if we're on the specific admin page (replace 'your_page_slug' with your page slug)
        if ( $screen && $screen->id === 'settings_page_translatepress-cleanup-db' ) {
            // Remove admin notices and all admin notices
            remove_all_actions('admin_notices');
            remove_all_actions('all_admin_notices');
        }
    }
    function add_settings_link($links) {

        // Define the URL for the settings page
        $url = get_admin_url() . "options-general.php?page=translatepress-cleanup-db";
        $settings_link = "<a href='$url'>Settings</a>";

        // Add the settings link to the beginning of the list of links
        array_unshift($links, $settings_link);
        return $links;
    }
}