<?php
namespace TranslatePressCleanupDb\Admin;

class ExcludeStrings
{
    public function __construct()
    {
        add_action('trp_skip_strings_containing_key_terms', [$this, 'exclude_strings']);
    }

    public function exclude_strings( $key_terms ): array {
        // Fetch options and trim any whitespace
        $line_separated_texts = trim(get_option('trpc_cleanup_line_separated_texts', ''));
        $exact_texts = trim(get_option('trpc_cleanup_line_separated_exact_texts', ''));

        // Initialize an empty array to hold the texts
        $texts_to_exclude = [];

        // Add non-empty line-separated texts to the array
        if (!empty($line_separated_texts)) {
            $texts_to_exclude = preg_split('/\r\n|\r|\n/', $line_separated_texts, -1, PREG_SPLIT_NO_EMPTY);
        }

        // Add non-empty exact texts to the array
        if (!empty($exact_texts)) {
            $texts_to_exclude = array_merge($texts_to_exclude, preg_split('/\r\n|\r|\n/', $exact_texts, -1, PREG_SPLIT_NO_EMPTY));
        }

        // Prepare the exclude array only if there are terms to exclude
        if (!empty($texts_to_exclude)) {
            $exclude = [
                'terms' => $texts_to_exclude,
                'operator' => 'or'
            ];
            $key_terms[] = $exclude;
        }

        return $key_terms;
    }

}