<?php
namespace TranslatePressCleanupDb\Admin;

class CleanupFailedDbOptimization
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_script']);
        add_action('wp_ajax_translatepress_cleanup_faild_db_optimization', [$this, 'handle_ajax_cleanup']);
    }

    public function enqueue_admin_script()
    {
        wp_enqueue_script('tpcleanfaileddboptimization-script', TPCLEANUP_URL . '/assets/tpcleanfaileddboptimization-script.js', array('jquery'), null, true);
        wp_localize_script('tpcleanfaileddboptimization-script', 'tpCleanFailedDbOptimizationAjax', array('ajax_url' => admin_url('admin-ajax.php')));
    }

    public function handle_ajax_cleanup()
    {
        // Check the nonce
        check_ajax_referer('translatepress-cleanup-failed-db-optimization', 'security');

        // Check if the current user is an administrator
        if (!current_user_can('manage_options')) {
            wp_send_json_error('You do not have permission to perform this action.');
            wp_die();
        }

        if(!class_exists('\TRP_Translate_Press')){
            return wp_send_json_error();
        }

        // Cleanup Batch
        $cleanup_successful = $this->cleanup_failed_optimizations_db();

        if ($cleanup_successful){
            $cleanup_message = "Cleanup Successful";
        } else
        {
            $cleanup_message = "Cleanup Failed";
        }
        // Return the progress
        $response = array(
            'message'      => $cleanup_message
        );

        // Send response back
        wp_send_json_success($response);
    }

    private function cleanup_failed_optimizations_db(){
        global $wpdb;

        delete_option('trp_original_strings_table_for_recovery');
        delete_option('trp_show_error_db_message');

        global $wpdb;

        // Query to get all table names that start with 'wp_trp_original1'
        $tables = $wpdb->get_col("SHOW TABLES LIKE '%_trp_original_strings1%'");

        // Loop through the result and drop each table
        foreach ( $tables as $table ) {
            $sql = "DROP TABLE `" . sanitize_text_field( $table ) . "`";
            $wpdb->query( $sql );
        }

        return true;
    }

}