#!/bin/bash

# Get the name of the current directory
dir_name=$(basename "$PWD")

# Create the archive path, placing it one level up from the current directory
archive_path="../${dir_name}.zip"

# If the archive already exists, remove it to ensure a fresh archive is created
if [ -f "$archive_path" ]; then
    rm "$archive_path"
    echo "Existing archive removed: $archive_path"
fi

# Create the zip archive, excluding the .git folder
zip -r "$archive_path" . -x ".git/*"

# Confirmation message
echo "Fresh archive created: $archive_path"
