jQuery(document).ready(function($) {
    var form = $('form[name="translatepress-cleanup-form"]');
    var progressDisplay = $('<p id="progress">Progress: </p>');
    var loadingIcon = $('<div id="loading-icon"></div>');

    // CSS for loading icon
    $('<style>')
        .prop('type', 'text/css')
        .html(`
            #loading-icon {
                display: none;
                width: 24px;
                height: 24px;
                border: 4px solid rgba(0, 0, 0, 0.1);
                border-radius: 50%;
                border-left-color: #000;
                animation: spin 1s linear infinite;
                margin: 20px;
            }

            @keyframes spin {
                to { transform: rotate(360deg); }
            }
        `)
        .appendTo('head');

    form.submit(function(e) {
        e.preventDefault();

        var lineSeparatedTexts = $('textarea[name="line_separated_texts"]').val();

        var confirmationMessage = "Are you sure you want to delete all matching strings found in the database? This action cannot be undone. \n\n" + lineSeparatedTexts;

        // Show the confirmation dialog
        if (!confirm(confirmationMessage)) {
            // If the user clicks "Cancel", don't submit the form
            return false;
        }

        form.after(progressDisplay);
        form.after(progressDisplay).after(loadingIcon);

        var batchSize = $('input[name="batch-size"]').val() || 2000;
        totalStringsDeleted = 0;



        function processBatch(tableName) {
            loadingIcon.show();

            $.post(tpcleanupAjax.ajax_url, {
                action: 'translatepress_cleanup_database',
                security: form.find('input[name="_wpnonce"]').val(),
                batch_size: batchSize,
                line_separated_texts: lineSeparatedTexts,
                table_name: tableName
            }, function(response) {
                if (response.success) {
                    stringsDeleted = response.data.strings_deleted ?? 0;
                    tableName = response.data.table_name ?? 'no table name is detected'
                    totalStringsDeleted += stringsDeleted;
                    progressDisplay.text('Progress for '+ tableName + ': ' + totalStringsDeleted + ' items deleted');

                    // Check if the process is finished
                    if (!response.data.finished) {
                        processBatch(tableName); // Call the next batch
                    } else {
                        progressDisplay.text('Cleanup complete! Total Strings Deleted ' + totalStringsDeleted);
                        loadingIcon.hide();
                    }
                } else {
                    progressDisplay.text(response.data);
                    loadingIcon.hide();
                }
            });
        }

        // Start the first batch
        processBatch();
    });
});