jQuery(document).ready(function($) {
    var form = $('form[name="translatepress-cleanup-failed-db-optimization-form"]');
    var progressDisplay = $('<p class="progress">Progress: </p>');
    var loadingIcon = $('<div class="loading-icon"></div>');

    form.submit(function(e) {
        e.preventDefault();

        form.after(progressDisplay);
        form.after(progressDisplay).after(loadingIcon);

        var batchSize = $('input[name="batch-size"]').val() || 2000;

        var totalStringsDeleted = 0;
        function processBatch() {
            loadingIcon.show();

            $.post(tpCleanFailedDbOptimizationAjax.ajax_url, {
                action: 'translatepress_cleanup_faild_db_optimization',
                security: form.find('input[name="_wpnonce"]').val()
            }, function(response) {
                if (response.success) {
                    message = response.data.message;
                    progressDisplay.text(message);
                    loadingIcon.hide();
                }
            });
        }

        // Start the first batch
        processBatch();
    });
});